/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.handlers;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.helper.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.CreateTweaker;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.crusher.CrushingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeSerializer;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=CrushingRecipe.class)
public class CrushingRecipeHandler
implements IRecipeHandler<CrushingRecipe> {
    public String dumpToCommandString(IRecipeManager iRecipeManager, CrushingRecipe recipe) {
        return String.format("<recipetype:create:crushing>.addRecipe(\"%s\", [%s], %s, %s);", recipe.m_6423_(), recipe.getRollableResults().stream().map(CreateTweaker::mapProcessingResult).map(Percentaged::getCommandString).collect(Collectors.joining(", ")), IIngredient.fromIngredient((Ingredient)((Ingredient)recipe.m_7527_().get(0))).getCommandString(), recipe.getProcessingDuration());
    }

    public Optional<Function<ResourceLocation, CrushingRecipe>> replaceIngredients(IRecipeManager manager, CrushingRecipe recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList((NonNullList)recipe.m_7527_(), Ingredient.class, (Recipe)recipe, rules, newIngredients -> id -> {
            ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(((ProcessingRecipeSerializer)AllRecipeTypes.CRUSHING.getSerializer()).getFactory(), id);
            builder.withItemOutputs((ProcessingOutput[])recipe.getRollableResults().toArray(ProcessingOutput[]::new));
            builder.withItemIngredients(newIngredients);
            builder.withFluidIngredients(recipe.getFluidIngredients());
            builder.requiresHeat(recipe.getRequiredHeat());
            builder.duration(recipe.getProcessingDuration());
            return (CrushingRecipe)builder.build();
        });
    }
}

